/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.resources;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.AbstractUniformResource;
import com.aptana.core.resources.IUniformResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public abstract class UniformResourceStorage
extends PlatformObject
implements IStorage {
    private long timestamp = -1L;
    private long expires = -1L;

    protected UniformResourceStorage() {
    }

    public abstract URI getURI();

    public Object getAdapter(Class adapter) {
        if (IUniformResource.class == adapter) {
            return new AbstractUniformResource(){

                public Object getAdapter(Class adapter) {
                    if (IStorage.class == adapter) {
                        return UniformResourceStorage.this;
                    }
                    return super.getAdapter(adapter);
                }

                public URI getURI() {
                    return UniformResourceStorage.this.getURI();
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        return obj instanceof UniformResourceStorage && this.getURI().equals(((UniformResourceStorage)((Object)obj)).getURI());
    }

    public int hashCode() {
        return this.getURI().hashCode();
    }

    public boolean isValid() {
        if (this.timestamp == -1L) {
            return false;
        }
        if (this.expires >= System.currentTimeMillis()) {
            return true;
        }
        try {
            URLConnection connection = this.getURI().toURL().openConnection();
            if (connection instanceof HttpURLConnection) {
                connection.setIfModifiedSince(this.timestamp);
                ((HttpURLConnection)connection).setRequestMethod("HEAD");
            }
            connection.connect();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                long lastModified = httpConnection.getLastModified();
                if (httpConnection.getResponseCode() == 304 || lastModified != 0L && this.timestamp >= lastModified) {
                    this.expires = System.currentTimeMillis();
                    long expiration = connection.getExpiration();
                    long date = connection.getDate();
                    this.expires = expiration != 0L && date != 0L && expiration > date ? (this.expires += expiration - date) : (this.expires += 10000L);
                    return true;
                }
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
        }
        return false;
    }

    public InputStream getContents() throws CoreException {
        try {
            URLConnection connection = this.getURI().toURL().openConnection();
            connection.connect();
            this.expires = System.currentTimeMillis();
            long expiration = connection.getExpiration();
            long date = connection.getDate();
            this.expires = expiration != 0L && date != 0L && expiration > date ? (this.expires += expiration - date) : (this.expires += 10000L);
            this.timestamp = connection.getLastModified();
            return connection.getInputStream();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.core", 0, "Open stream error", (Throwable)e));
        }
    }

    public boolean exists() {
        try {
            HttpURLConnection httpConnection;
            URLConnection connection = this.getURI().toURL().openConnection();
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setRequestMethod("HEAD");
            }
            connection.connect();
            if (connection instanceof HttpURLConnection && (httpConnection = (HttpURLConnection)connection).getResponseCode() == 200) {
                return true;
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
        }
        return false;
    }

    public IPath getFullPath() {
        return null;
    }

    public String getName() {
        int index;
        String name = this.getURI().getPath();
        if (name != null && (index = name.lastIndexOf(47)) >= 0) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public boolean isReadOnly() {
        return true;
    }
}

